"use strict";
//
// Copyright 2021 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const ReceiptCredential_1 = require("./ReceiptCredential");
const ReceiptCredentialPresentation_1 = require("./ReceiptCredentialPresentation");
const ReceiptCredentialRequestContext_1 = require("./ReceiptCredentialRequestContext");
class ClientZkReceiptOperations {
    constructor(serverPublicParams) {
        this.serverPublicParams = serverPublicParams;
    }
    createReceiptCredentialRequestContext(receiptSerial) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.createReceiptCredentialRequestContextWithRandom(random, receiptSerial);
    }
    createReceiptCredentialRequestContextWithRandom(random, receiptSerial) {
        return new ReceiptCredentialRequestContext_1.default(Native.ServerPublicParams_CreateReceiptCredentialRequestContextDeterministic(this.serverPublicParams.getContents(), random, receiptSerial.getContents()));
    }
    receiveReceiptCredential(receiptCredentialRequestContext, receiptCredentialResponse) {
        return new ReceiptCredential_1.default(Native.ServerPublicParams_ReceiveReceiptCredential(this.serverPublicParams.getContents(), receiptCredentialRequestContext.getContents(), receiptCredentialResponse.getContents()));
    }
    createReceiptCredentialPresentation(receiptCredential) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.createReceiptCredentialPresentationWithRandom(random, receiptCredential);
    }
    createReceiptCredentialPresentationWithRandom(random, receiptCredential) {
        return new ReceiptCredentialPresentation_1.default(Native.ServerPublicParams_CreateReceiptCredentialPresentationDeterministic(this.serverPublicParams.getContents(), random, receiptCredential.getContents()));
    }
}
exports.default = ClientZkReceiptOperations;
//# sourceMappingURL=ClientZkReceiptOperations.js.map